﻿# Marvell FastLinQ Edge Network Adapter Windows Driver
Nov 11, 2020

## v3.0.18.0
_Date 18.11.2020_
* Added Hardware IDs for AQC113-based Asus NIC 
* Windows 8/8.1: enable PM by default for AQC113 (HCK requirement)
* Fixed RSC offload configuration (HLK test failure)
* Added workaround for OffloadLSO test failure in HLK 19041 

## v3.0.17.0
_Date 12.10.2020_
* Security checks for secure AQC113 parts

## v3.0.16.0
_Date 31.08.2020_
* Support for AQC113 B0 counters 
* Additional HWIDs for AQC113
* Advertise 2.5G/5G NBase-T speeds along with 2.5/5G Base-T 
* Add logging of 10Mbps link speed to system log.
* Fix reporting DeviceSleepOnDisconnect capability on AQC100
* Fix RSC & Hyper-V vSwitch problem 


## v3.0.15.0
_Date 09.06.2020_
* Low Power on Media Disconnect 
* Init-time instructions (as part of Low Power on Disconnect)
* Conformance to latest filtering spec: don't touch multicast filter 
* Enable EEE for AQC113 
* Fix TX stuck recovery logic 
* Fixes & improvements for RSS logic for AQC107/AQC113
* Fixes D0->D3 state transition: drain transmit before disable interrupts

## v3.0.14.0
_Date 05.05.2020_
* Filtering infrastructure 
* Dynamic interrupt resources allocation 
* Separate trace flag for firmware layer 
* Enable EEE at 1G link speed for AQC111/Bermuda 
* Improve RX checksum offload workaround for AQC107 
* Fix security checks on AQC107
* Remove auto-generation of MAC address
* Tidy up code 

## v3.0.13.0
_Date 27.03.2020_
* Wake Reason Indications 
* Provide firmware with the current MAC address 
* WMI interface (not compatible with 2.x driver) 
* Cable Diagnostics 
* Changes for NDISTest compatibility 
* Minor misc fixes and improvements

## v3.0.12.0
_Date 06.03.2020_
* Wake on ping behavior with ARP offload 
* Update reset sequence 
* Cleanup HAL 

## v3.0.11.0
_Date 18.02.2020_
* Fixes for NDISTest 
* Rework internal link parameters
* Update CI
* Update non-FF register to `0x1c`

## v3.0.10.0
_Date 05.02.2020_
* Set max frame length according to “Jumbo Packet” driver setting
* Add thermal shutdown support 
* Add downshift support 
* Link interrupt support
* Rework internal adapter state transitions

## v3.0.9.0
_Date 17.01.2020_
* Fix setting of packet filters for all multicast
* Fix setting of PFC
* Use standardized INF keywords for speed & duplex 
* Introduce support for 10Mbps link speed 
* Introduce support for half duplex

## v3.0.8.0: Alpha driver v3.0.8.0 for AQC113/AQC100
_Date 09.01.2020_
* Basic backward compatibility with AQC100
* Fixes for RSS multi-group
* Reworked interrupts logic
* Other minor fixes for AQC113

## v2.1.21.0
_Date 07.02.2020_
* Fix incorrect checksum reported to OS for packets with non-zero padding

## v2.1.20.0
_Date 10.01.2020_
* Don't use EEE for 1Gbit/s link speed 
* Enable EEE for specific HWID 
* Add HWIDs for HP Flatiron 

## v2.1.19.0
_Date 21.10.2019_
* Improved datapath performance
* Improved performance and stability in single interrupt mode
* Fixed `MPE_Ethernet` test sporadic failures
* Fixed RSC operation on Hyper-V hosts
* Added SNR data to Cable Diagnostics
* Fixed FCS error packets handling

## v2.1.18.0
_Date 23.05.2019_
* Backport bugfixes & improvements from XBOX branch
  * Incorrect wait conditions in reset sequence
  * Possible arithmetic overflow in `PerformanceCounter` code
  * Prevent crash when querying thermal information on higher IRQLs
* Fix RSC freeze _(stuck)_ situation
* Fix link event logging.
* Fix applying RSC configuration to hardware.
* Fix PNP timeout at NIC shutdown _(by crash dump from the MS Hardware Dashboard).
* Update default number of RSS queues.
* Avoid indicating SCU _(single coalesced unit aka LRO session)_ with FSC/L4 checksum errors to the OS network stack.
* Fix incorrect flow control settings for Rx only case.
* Workaround for the HW trait where L3 checksum can be verified incorrectly in some cases. 

## v2.1.17.0
_Date 29.01.2019_
* Fix checksum offload works incorrectly with padding.
* Ability to configure thermal shutdown via registry.
* Set valid file properties for property page.
* Disable RSC by default for Gigabyte.
* Implement PHY kickstart for flashless. It is currently disabled by default.

## v2.1.16.0
_Date 10.12.2018_
* Fix random disconnects and data path stuck on AQC111 _(by forcibly disabling PTP block).

## v2.1.15.0
_Date 04.12.2018_
* Fix Device Manager lock up when changing link speed. 
* Fix system crash when running cable diagnostics. 
* Add a missing lock acquire. 

## v2.1.14.0
_Date 16.11.2018_
* Work on one MSI message.
* Fix for broken legacy interrupt handler.
* Fix for transmit path deadlock in some rare cases.

## v2.1.12.0
_Date 19.10.2018_
* Change device description string for QNAP. 
* Modify _"Link Speed"_ setting for ASUS XG-C100F.
* Resolve warnings when compiling with warning level 4 (`/W4`) option. 
* Fix for transmit path rundown during the test _"DF PnP Surprise Remove"_.
* Remove flash update functionality.

## v2.1.10.0
_Date 27.09.2018_
* Service name changed to match the driver name.
* Fix for receive path stuck under heavy load. 
* Fix for statistics not reported correctly via WMI (`MSFT_NetAdapterStatisticsSettingData` class).
* Fix for flow control settings not configured correctly in some cases. 
* Fix for "Wake from Power Off" feature works incorrectly if fastboot is enabled.

## v2.1.009.0
_Date 03.08.2018_
* Fix for the PHY temperature reported via WMI is always zero. 
* Fix for parameter in the INF-file related to the strict speed policy.

## v2.1.008.0
_Date 04.07.2018_
* Fix error handling on resource allocations

## v2.1.007.0
_Date 03.07.2018_
* Added Tx stuck Firmware interrupt handler that triggers Tx path reset sequence in both H/W and S/W.  
This is a workaround for Felicity 1G SGMII PAUSE problem.
* Strict speed policy - only chosen speed is advertised.
Policy can be changed through either INF-file or registry.
* Perform NIC reset when PHY global fault is detected on Felicity.
* Take control over eFUSE before reading.
* New Tx data path w/SGDMA. 

## v2.1.006.0
_Date 26.05.2018_
* Reallocate stale NBLs instead of using work item after suspend resume
* Major code refactoring

## v2.1.005
_Date 17.04.2018_
* Fix for mailbox ready wait loop on B1 hardware
* Fix for incorrect system log entry (security check failure) if a device surprisingly removed during a security check
* Fix for incorrect link speed being reported after cable unplug in PowerShell 
* Fix for reset sequence incompatibility with firmware 1.x with "dirty wake" feature
* Fixes related to power management and power state transitions 

## v2.1.004
_Date 15.02.2018_
* INF-file co-installer section fix.

## v2.1.003
_Date 14.02.2018_
* Reset sequence fix: safely reset the SPI interface.

## v2.1.002
_Date 09.02.2018_
* Settings from _"Power Management"_ tab take precedence over driver WoL settings from _"Advanced"_ tab.
* Power state transitions refactoring.
* Configuration of thermal shutdown (if supported by F/W). Temperature thresholds are: shutdown at 108C, warning at 100C, back to normal at 80C.
* Added messages in system event log if temperature rises above warning threshold and returns back to normal after thermal warning.
* Added property page on Windows 7, 8, 8.1
* Reset SPI interface explicitly during RBL reset sequence (reset sequence fix)
* Trace improvements in case of RBL failure
* Embedded F/W image for host boot updated to **v2.9.71**
* Fix: BSOD if TB removed during sleep

## v2.1.001
_Date 25.12.2017_
* Use bit in uP control register for 'Reset Guard' instead of scratchpad register `0x300`.
* Detect global H/W fault and report it in system event log. Unique event message for thermal shutdown fault.
* Fix: broken EEE in driver on 1.x F/W
    
## v2.1.000
_Date 22.12.2017_
* F/W 1.x support
* B0 HWIDs added to INF-file
* Firmware (flash) update support (F/W 1.x only)
* User-friendly messages in system event log
* New link-up behavior: allow all speeds that less or equal currently selected speed
* PHY log control (enable/disable) via WMI.
* Logging support PowerShell scripts (for collecting and separation). Logs are collected in binary format
* 'Reset Guard' for unexpected MAC reset detection (the MAC scratchpad register `0x300` is used)
* Use F/W 2.x/3.x link drop capability for shutting down link during driver unload or network stack state transitions
* Fix: MRRS 
* Fix: PM_PowerStateTransition test fails
* Other minor improvements 

## v2.0.026
_Date 16.11.2017_
* Update reset sequence

## v2.0.025
_Date 16.11.2017_
* Improve security checks: chip revision check.
* Fixed: reading F/W logs

## v2.0.024
_Date 14.11.2017_
* Raw F/W logs (via WMI)
* Embedded F/W image for host boot updated to **v2.9.54**

## v2.0.023
_Date 03.11.2017_
* Minor INF-file changes for WHQL (LSOv1).

## v2.0.022
_Date 02.11.2017_
* Fix: remove a duplicate key from INF strings section

## v2.0.021
_Date 31.10.2017_
* Driver rename to `aqnic`.

## v2.0.020
_Date 27.10.2017_
* Fixed: driver fails to start on some secure HWIDs
* Trace improvements during driver initialization

## v2.0.019
_Date 25.10.2017_
* Fixed wake on pattern from shutdown
* Rollback reset sequence fix for Felicity (issue with reset

## v2.0.018
_Date 23.10.2017_
* Implemented security checks for secure chips
* Improved reset sequence for Felicity
* Boot from host (flashless) is disabled

## v2.0.016
_Date 02.10.2017_
* F/W 3.x ready
* Fix: RX buffer allocation
* Feature: downshift
* Feature: wake on ping
* Feature: DSP-based cable length (via WMI)
* Feature: thermal information: PHY and MAC temperature (via WMI)
* Separated INF-file for Apple
* INF-file refactoring
